#include "nexgendash.h"

volatile bool bNetworkingUp = FALSE;

extern HRESULT httpd_init();
extern HRESULT ftpd_init();

IN_ADDR MYIP;

DWORD netstate;

DWORD WINAPI IPAddrThread( LPVOID lpParam ) {
	XNADDR xnaddr;
	XNKID xnkid;
	IN_ADDR ipaddr, lipaddr;
	char szip[16];
	DWORD state, lstate=0;

	memset(&xnkid, 0, sizeof(xnkid));
//	lstate=XNetGetTitleXnAddr( &xnaddr );
//	XNetXnAddrToInAddr( &xnaddr, &xnkid, &lipaddr );
	
	while(bNetworkingUp==TRUE) {
		Sleep(5000);

		state=XNetGetTitleXnAddr( &xnaddr );
		if(state!=lstate) {
			if(state==XNET_GET_XNADDR_PENDING)
				OutputDebugString("IP address assignment pending.\n");
			if(state&XNET_GET_XNADDR_PPPOE)
				OutputDebugString("IP address assigned by PPPOE.\n");
			if(state&XNET_GET_XNADDR_DHCP)
				OutputDebugString("IP address assigned by DHCP.\n");
			if(state&XNET_GET_XNADDR_STATIC)
				OutputDebugString("IP address static.\n");
			if(state&XNET_GET_XNADDR_DNS)
				OutputDebugString("DNS configured.\n");
			if(state&XNET_GET_XNADDR_GATEWAY)
				OutputDebugString("Gateway configured.\n");
			if(state&XNET_GET_XNADDR_ETHERNET)
				OutputDebugString("Host has Ethernet address.\n");
			if(state&XNET_GET_XNADDR_NONE)
				OutputDebugString("I have no IP!.\n");
			if(state&XNET_GET_XNADDR_ONLINE)
				OutputDebugString("Online Service Detected.\n");
			lstate=state;
			netstate=state;
		}
		ipaddr=xnaddr.ina;
		if(memcmp(&ipaddr, &lipaddr, sizeof(ipaddr))) {
			XNetInAddrToString( ipaddr, szip, 16);
			OutputDebugString("IP Address : ");
			OutputDebugString(szip);
			OutputDebugString("\n");
			lipaddr=ipaddr;
			MYIP=ipaddr;
		}
	}

	return 0;
}

HRESULT IPAddrThread_Start() {
	DWORD	dwThreadId;
	HANDLE	hThread; 

	hThread = CreateThread( 
		NULL,						// (this parameter is ignored)
		0,							// use default stack size  
		IPAddrThread,				// thread function 
		NULL,					// argument to thread function 
		0,							// use default creation flags 
		&dwThreadId);				// returns the thread identifier 
 
	// Check the return value for success. 
	if (hThread == NULL) 
	{
		OutputDebugString( "IPAddrThread creation failed.\r\n" );
	}

	OutputDebugString( "IPAddrThread creation succeeded.\r\n" );
	CloseHandle( hThread );
	return S_OK;
}

void network_init() {
	DWORD dwNetStatus;
	XNetStartupParams xnsp;
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	
	if(bNetworkingUp == TRUE) return;

	dwNetStatus=XNetGetEthernetLinkStatus();

	if(!(dwNetStatus & XNET_ETHERNET_LINK_ACTIVE)) return;

	// Initialize Xbox Networking
	memset(&xnsp, 0, sizeof(xnsp));
	xnsp.cfgSizeOfStruct = sizeof(XNetStartupParams);
	xnsp.cfgFlags = XNET_STARTUP_BYPASS_SECURITY;
	err = XNetStartup(&xnsp);
	if ( err != 0 ) return;

	// Initialize Winsock
	wVersionRequested = MAKEWORD( 2, 2 );
	err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 ) return;
	if ( LOBYTE( wsaData.wVersion ) != 2 || HIBYTE( wsaData.wVersion ) != 2 ) {
		WSACleanup( );
		return; 
	}

	bNetworkingUp=TRUE;

	IPAddrThread_Start();

	httpd_init();
	ftpd_init();
}

